* Do-fil til kapittel 9
****************************************
* Eksempel 1 flernivåanalyse av timelønn i virksomheter
***********
use "https://nedlasting.fagbokforlaget.no/stata/wage89.dta", clear
list in 1/15, compress /* Lister de 15 første */
summ   /* Beskrivende statistikk */
*******************
* Trinn 1 Nullmodellen ned intraklassekorrelasjonen
*************
mixed wage || firmno: 
estat icc  
*** Tusenbeindiagram (caterpillar plot)
egen ansatte = count (age), by(firmno)  /* #ansatte per virksomhet */
mixed wage || firmno:
predict u0, reffects
predict u0se, reses
egen pickone = tag(firmno)
sort u0
generate u0rank = sum(pickone)
serrbar u0 u0se u0rank if pickone==1 & ansatte > 9, scale(1.96) yline(0) 
****************
* Trinn 2 utvikle modellen for nivå 1
********
mixed wage edyears c.age##c.age female || firmno:
* pseudo R2
di (643.936 - 476.334)/643.936   /* R2 nivå 1 */
di (260.893 - 116.291)/260.893   /* R2 nivå 2 */
* Lagre estimatene fra modellen med stokastisk konstant
estimates store ri
*****************************
* Trinn 3 Utvikle den stokastiske delen av modellen
**********
mixed wage edyears c.age##c.age female || firmno: edyears, cov(un)
estimates store red
* Teste om koeffisienten til edyears varierer signifikant
lrtest ri red 
mixed wage edyears c.age##c.age female || firmno: edyears
estimates store red2
lrtest red2 red 
***************************************
* Visualisering av stokastiske effekter
**********
egen ansatte = count (age), by(firmno)  /* #ansatte per virksomhet */
****************
** Enkel modell med stokastisk regresjonskonstant
mixed wage edyears  || firmno: 
*** Plotte parallelle reg linjer for hver virksomhet */
predict pwage, fitted
egen pickone = tag(firmno edyears)
sort firmno edyears
twoway connected pwage edyears if pickone==1 & ansatte > 9, ///
  connect(ascending) recast(line) xlabels(0 2 4 6 8 10) ///
  ytitle(EB-predikert timelønn) xtitle(Utdanning(år) etter grunnskole) ///
  title(Stokastisk regresjonskonstant)
************
** Enkel modell med stokastisk regresjonskoeffisient
mixed wage edyears  || firmno: edyears, cov(un)
predict pwage2, fitted
twoway connected pwage2 edyears if pickone==1 & ansatte > 9, ///
  connect(ascending) recast(line) xlabels(0 2 4 6 8 10) ///
  ytitle(EB-predikert timelønn) xtitle(Utdanning(år) etter grunnskole) ///
  title(Stokastisk regresjonskoeffisient)
**************
* Trinn 4 legge til kontekstuelle forklaringsvariabler
**********
summ size, detail
gen lnsize = ln(size)
histogram size
histogram lnsize
* Modell med interaksjon mellom utdanning og virksomhetsstørrelse4
mixed wage c.edyears##c.lnsize c.age##c.age female || firmno: edyears
* Endelig modell uten interaksjon med lnsize
mixed wage edyears c.age##c.age female lnsize || firmno: edyears
** Framstille effektev av lnsize grafisk
margins, at(lnsize=(0(1)9))
marginsplot, recast(line) recastci(rarea)
** OLS regresjon med klyngekorrigerte standardfeil
regress wage edyears c.age##c.age female lnsize, vce(cluster firmno)
***********************
* Eksempel 2 lykke i Europa, ESS6 29 land
************
* Datafilen er hentet fra ESS MULTILEVEL DATA
* http://www.europeansocialsurvey.org/data/multilevel/
use "https://nedlasting.fagbokforlaget.no/stata/ESS6_lykke.dta", clear
encode cntry, generate(country) /* Numerisk landvariabel */
* Avhengig variabel: happy - kan brukes som den er
clonevar alder = agea
recode gndr (1=0 Mann)(2=1 Kvinne), generate(kvinne)  /* kjønn */
label variable kvinne "Kjønn, fra gndr"
* Utdanning baseres på eduyrs, men den har mange urimelige verdier.
* Løsning setter alle over 25 års utdanning til missing
recode eduyrs (26/51 = .), gen (utdann)  /* 191 settes til missing */
label variable utdann "År utdanning totalt, fra eduyrs"
recode icpart1 (1=1 "Bor sammen")(2=0 "Bor alene"), gen(samboer)
recode hincfel (1 2 = 1 "Klarer seg") (3 4=0 "Problematisk"), gen(copeinc)
label variable copeinc "Klarer seg med inntekten, fra hincfel"
label variable samboer "Bor sammen med ektefelle/partner/samboer, fra icpart1"
recode sclmeet (1/4=0 "Sjelden")(5/7=1 "Ofte"), gen(sosial)
label variable sosial "Møte med venner, fra sclmeet"
clonevar relig = rlgdgr
recode health (1 2 = 1 "god")(3 4 5=0 "Dårlig"), generate(helse)
numlabel, add   /* legger til kodetall i verdietiketter */
* Beskrivende statistikk for alle aktuelle variabler
summ happy alder kvinne utdann copeinc samboer sosial relig helse  ///
  c_hdihdr_2012 c_mpi_2012 c_gii_2012 c_empinx_2011 ///
  c_wecon_2011 c_wopol_2011 c_wosoc_2007
* Korrelasjoner mellom landvariabelr og lykke
corr happy c_hdihdr_2012 c_gii_2012 c_empinx_2011 ///
  c_wecon_2011 c_wopol_2011 c_wosoc_2007
*** Lage missing indikator
egen nmiss = rowmiss (happy alder kvinne utdann copeinc samboer sosial ///
  relig helse c_hdihdr_2012 c_gii_2012)
tabu nmiss
**** Nullmodellen med ICC
mixed happy || cntry:  if nmiss==0
estat icc
* Tusenbein diagram (Caterpillar plot) basert på nullmodellen
predict u0, reffects
predict u0se, reses
egen pickone = tag(cntry)
sort u0
generate u0rank = sum(pickone)
serrbar u0 u0se u0rank if pickone==1, scale(1.96) yline(0) 
* Liste landerffekter
list cntry u0 u0rank if pickone==1
*
*** Fullstendig indivinivåmodell
mixed happy c.alder##c.alder kvinne utdann copeinc samboer sosial ///
  relig helse || cntry: if nmiss==0
estat icc 
* Beregne forklart varians
di (0.588 - 0.232)/0.588   /* Nivå 2 */
di (3.729 - 3.116)/3.729   /* Nivå 1 */
*** Legger til begge nivå-2 variabler
mixed happy c.alder##c.alder kvinne utdann copeinc samboer sosial ///
  relig helse c_hdihdr_2012 c_gii_2012 || cntry: if nmiss==0
*** Endelig modell med bare HDI som nivå-2-variabel
mixed happy c.alder##c.alder kvinne utdann copeinc samboer sosial ///
  relig helse c_hdihdr_2012  || cntry: if nmiss==0
*** Plotte for hdi
margins, at(c_hdihdr_2012=(0.7(0.01)0.96))
marginsplot, recast(line) recastci(rarea)
*** Forklart varians på landnivået
di (0.588 - 0.096)/0.588   /* Nivå 2 */

